//=============================================================================
// SingleActorGame
// MRP_SingleActorGame.js
// By Magnus0808 || Magnus Rubin Peterson
//=============================================================================

/*:
* @plugindesc Removes actor select windows.
* @author Magnus0808
*
* @help Plug and play. Place as the FIRST plugin.
*/

var Imported = Imported || {};
Imported.MRP_SingleActorGame = true;

var MRP = MRP || {};
MRP.SingleActorGame = MRP.SingleActorGame ||{};

(function() {
   
    Scene_Menu.prototype.createCommandWindow = function() {
        this._commandWindow = new Window_MenuCommand(0, 0);
        this._commandWindow.setHandler('item',      this.commandItem.bind(this));
        this._commandWindow.setHandler('skill',     this.onPersonalOk.bind(this));
        this._commandWindow.setHandler('equip',     this.onPersonalOk.bind(this));
        this._commandWindow.setHandler('status',    this.onPersonalOk.bind(this));
        this._commandWindow.setHandler('options',   this.commandOptions.bind(this));
        this._commandWindow.setHandler('save',      this.commandSave.bind(this));
        this._commandWindow.setHandler('gameEnd',   this.commandGameEnd.bind(this));
        this._commandWindow.setHandler('cancel',    this.popScene.bind(this));
        this.addWindow(this._commandWindow);
    };
   
    Scene_Battle.prototype.onSelectAction = function() {
        var action = BattleManager.inputtingAction();
        this._skillWindow.hide();
        this._itemWindow.hide();
        if (!action.needsSelection()) {
            this.selectNextCommand();
        } else if (action.isForOpponent()) {
            this.selectEnemySelection();
        } else {
            var action = BattleManager.inputtingAction();
            action.setTarget(0);
            this.selectNextCommand();
        }
    };
   
    Scene_ItemBase.prototype.itemTargetActors = function() {
        var action = new Game_Action(this.user());
        action.setItemObject(this.item());
        if (!action.isForFriend()) {
            return [];
        } else if (action.isForAll()) {
            return $gameParty.members();
        } else {
            return [$gameParty.members()[0]];
        }
    };
   
    Scene_ItemBase.prototype.determineItem = function() {
        var action = new Game_Action(this.user());
        var item = this.item();
        action.setItemObject(item);
        this.useItem();
        this.activateItemWindow();
    };
   
    Window_MenuCommand.prototype.makeCommandList = function() {
        this.addMainCommands();
        this.addOriginalCommands();
        this.addOptionsCommand();
        this.addSaveCommand();
        this.addGameEndCommand();
    };
   
   
})();